/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.paginas;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.ui.asistentes.PaginaAsistente;
import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class ImportarAnexoPaginaBusqueda
extends PaginaAsistente {
    private static final long MAX_TAMANO_ARCHIVO_IMPORTAR_BYTES = 0x400000L;
    private Text txtRutaArchivo;
    private File archivoXML;
    private boolean esImportacion;

    public ImportarAnexoPaginaBusqueda(boolean esImportacion) {
        super("ImportarAnexoPaginaBusqueda", "Anexo Transaccional", "Seleccione un archivo para importar.");
        this.esImportacion = esImportacion;
    }

    public File getArchivoXML() {
        return this.archivoXML;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblArchivoXmlDe = new Label(container, 0);
        lblArchivoXmlDe.setText("Archivo XML del Anexo:");
        new Label(container, 0);
        this.txtRutaArchivo = new Text(container, 2048);
        this.txtRutaArchivo.setBackground(SWTResourceManager.getColor((int)1));
        this.txtRutaArchivo.setEditable(false);
        this.txtRutaArchivo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnBuscar = new Button(container, 0);
        btnBuscar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialogoBuscarXML = new FileDialog(ImportarAnexoPaginaBusqueda.this.getShell());
                dialogoBuscarXML.setText("Buscar Anexo Transaccional");
                dialogoBuscarXML.setFilterNames(new String[]{"Archivos XML"});
                dialogoBuscarXML.setFilterExtensions(new String[]{"*.xml"});
                String rutaArchivo = dialogoBuscarXML.open();
                if (StringUtil.isNullOrEmpty((String)rutaArchivo)) {
                    ImportarAnexoPaginaBusqueda.this.txtRutaArchivo.setText("");
                    ImportarAnexoPaginaBusqueda.this.setPageComplete(false);
                    return;
                }
                File archivoSeleccionado = new File(rutaArchivo);
                ImportarAnexoPaginaBusqueda.this.txtRutaArchivo.setText(rutaArchivo);
                if (!archivoSeleccionado.exists()) {
                    ImportarAnexoPaginaBusqueda.this.setErrorMessage("El archivo especificado no existe.");
                    ImportarAnexoPaginaBusqueda.this.setPageComplete(false);
                    ImportarAnexoPaginaBusqueda.this.archivoXML = null;
                    return;
                }
                if (ImportarAnexoPaginaBusqueda.this.esImportacion && archivoSeleccionado.length() > 0x400000L) {
                    ImportarAnexoPaginaBusqueda.this.setErrorMessage("El tama\u00f1o del archivo excede el l\u00edmite de 4096 kB (4 MB) que el DIMM soporta para este Anexo");
                    ImportarAnexoPaginaBusqueda.this.setPageComplete(false);
                    ImportarAnexoPaginaBusqueda.this.archivoXML = null;
                    return;
                }
                ImportarAnexoPaginaBusqueda.this.archivoXML = archivoSeleccionado;
                ImportarAnexoPaginaBusqueda.this.setErrorMessage(null);
                ImportarAnexoPaginaBusqueda.this.setPageComplete(true);
            }
        });
        btnBuscar.setText("Buscar...");
    }
}

